# Vespucci 21.2 Highlights

2025-11-29

### Support for uploading images to Panoramax instances and Wikimedia Commons

We have added support for uploading individual images both to Panoramax instances and Wikimedia Commons. Currently you can upload images from 
the element selection modes, automatically adding a corresponding link to the OSM element and from the image viewer.

Before you upload you need to configure and authorize the destinations, see [Setting up image storage locations](https://vespucci.io/tutorials/setting_up_image_storage_locations/) for more information on that.

### Support for custom changeset tags

You can now add additional changeset tags for your uploads in a further tab in the upload modal. Tags added in the _Persistent_ section will be saved and reused for future uploads, 
those added in the _Transient_ part will only be added to the current upload.

### Improvements _Review_ modal

We've improved the behaviour of the _Review_ dialog to retain state even if you explicitly or implicitly (for example via a version comparison dialog) exit it. This allows you to systematically inspect
all objects you want to upload via the modal without having to restart the selection process. 

We've further changed the behaviour so that when you select or de-select an element that requires other elements these will be selected / de-selected too giving you better visual feedback.

We are planning to make it possible to run the review modal in a separate window in a future version this will make it easier to use on tablets.

### Support for multiple tag filter configurations

You can now create multiple sets of tag filters and save them on device. You can switch between these either in the filter activity or by long pressing the filter button and selecting the corresponding item
from a menu. 

This and all other similar configuration activities now display a floating action button with a __+__ for adding additional items.

### Improved node merging behaviour

Previously node merging could seem seem to be inconsistent. This was due to the default behaviour being to merge the selected node in to the nearby node except if that node had "more" history
than the selected node, in that case we would swap the nodes (to maintain the history). In this situation the position of the resulting, merged, node would change from the default.

We've changed how this works now to always retain the original position of the target node, even if we switch the elements to retain history. Long pressing the merge button will reverse the merge 
behaviour to merge the nearby nodes in to the selected node. 

### Improved selection of Overpass query results

When a Overpass query returns data and you have the option enabled to automatically select it, we cannot know which elements are a direct result of the query, and which are returned simply as
child elements required by their parents, in particular way nodes. In the past to somewhat reduce the issues this causes, we have simply not selected untagged way nodes, but that will not work for 
example for entrance nodes on building outlines and other similar cases.

For overpass queries that were created from a search expression we can improve on this by simply running the original expression without overpass specific terms on the downloaded data, which was implemented for 
this release.   

### Updated privacy statement

We've updated [our privacy statement](Privacy.md) with information on Panoramax and Wikimedia Commons. 

### Other behaviour changes 

- Add support for compressed request bodies for HTTP PUT.
- Store chunk number in custom changeset tag for chunked uploads instead of in the comment tag.
- Add styling for highway=scramble.
- Add styling for natural=gully.
- Add support for "invert selection" in property editor tabs.
- Add tag2link support and use it instead of hardwired links in ElementInfo.
- Add API configuration for OpenHistoryMap.
- Make thresholds for way moving warnings user adjustable 
- Add warning for too many, that is more than 50%, non-visible way nodes when moving way. 

## Miscellaneous

# Upgrading from previous versions

As a general precaution you should upload any pending changes before updating, particularly if you are upgrading from any major version that doesn't immediately precede this one. 

# Known problems

* The documentation is out of date.
* For other known problems with this build please see [our issue tracker](https://github.com/MarcusWolschon/osmeditor4android/issues)
